<?php
/**
 * Template Name: Membership
 *
 * Description: Template withour sidebar
 *
 * @package WordPress
 * @subpackage Kleo
 * @author SeventhQueen <themesupport@seventhqueen.com>
 * @since Kleo 1.0
 */

get_header(); ?>

<?php get_template_part('page-parts/general-title-section'); ?>

<div class="member-ship_page">
<div class="container">

  <?php //echo site_url();?>

<?php if (!is_user_logged_in()) { ?>
  <p>You need to register first before choosing any membership. <a href="<?php echo site_url();?>/register">Register</a></p>
  <p>If you already have an account <a href="<?php echo site_url();?>/register">Login</a></p>
<?php } ?>

  <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
    <div class="box_1">
      <h2>BASIC</h2>

      <?php if (is_user_logged_in()) { ?>
        <h3>Your Plan</h3>
      <?php } ?>

      <h3>Complimentary</h3>
      <!-- <h2>&pound; 0</h2> -->
      <ul class="extra-description">
        <li>We host exclusive member-only events throughout the year with an opportunity to meet UK leading entrepreneurs</li>
        <li>A basic business profile on our members-only online portal </li>
        <li>Access to other E2E member's profiles and E2E discussion forums</li>
        <li>Needing finance: Access E2E’s £50 million financing facility for SMEs with GBP 1m+ turnover</li>
        <li>Save money on offices: 3 months FREE on any IWG UK and Spaces suite packages</li>
        <li>Our employment law experts Ellis Whittam offer 3 months FREE use of their online HR/ employment law support services</li>
        <li>Access to professional advice and services to help you to scale your business</li>
        <li>Access to selected content on E2E's knowledge hub</li>
        <li>E2E will promote you on our website</li>
      </ul>
    </div>
  </div>
  <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
    <div class="box_1">
      <div class="service-1 click1">
        <div class="row">
          <div class="medium-12 small-12 columns smalldesc">
            <h2>PREMIUM</h2>
            <?php if (is_user_logged_in()) { ?>
              <?php //echo $_SERVER['REQUEST_URI'].'--------'.site_url(); ?>
              <h3>Click here to <a href="<?php echo site_url(); ?>/membership-account/membership-checkout/?level=3">Upgrade</a></h3>
            <?php } ?>
      
            <h3><strong>&pound; 10.00</strong> Per Month.</h3>
            <!-- <h2>&pound; 10<sup>.00</sup></h2> -->
            <ul class="extra-description">
              <li>Priority booking for all E2E events</li>
              <li>An enhanced business profile on our members-only online portal</li>
              <li>Full interaction and direct messaging via our portal</li>
              <li>The opportunity to participate in private ‘premium members only’ discussion forums</li>
              <li>E2E investment/investor support; we can help you to make the right investment or raise the critical funds you need to succeed</li>
              <li>E2E Non-Exec Director support; we connect experienced Non-Exec Directors from our community with the UK’s leading SMEs</li>
              <li>Bespoke business support and mentoring from E2E’s trusted network</li>
              <li>Extended access to a suite of corporate services via our partners, some at discounted/ E2E preferential rates</li>
              <li>Full Access to content on E2E's knowledge hub</li>
              <li>E2E will promote you on our website and on our social media platforms</li>
            </ul>
          </div>
          <!-- <a href="#" class="read-more">Read More</a> --> </div>
      </div>
    </div>
  </div>
</div>
</div>


<script>
    $('.click1').find('a[href="#"]').on('click', function (e) {
    e.preventDefault();
    this.expand = !this.expand;
    $(this).text(this.expand?"Hide Content":"Read More");
    $(this).closest('.click1').find('.smalldesc, .bigdesc').toggleClass('smalldesc bigdesc');
});
</script>

<?php get_footer(); ?>