<?php
/**
 * BuddyPress - Members Register
 *
 * @package BuddyPress
 * @subpackage bp-legacy
 */
// echo $_SERVER['DOCUMENT_ROOT']; exit();

include_once $_SERVER['DOCUMENT_ROOT'].'/CMS/E2E/wp-blog-header.php';

global $wpdb;

?>
<h2 style="text-align: center;">REGISTER</h2>
<div id="buddypress">

	<?php

	/**
	 * Fires at the top of the BuddyPress member registration page template.
	 *
	 * @since 1.1.0
	 */
	do_action( 'bp_before_register_page' ); ?>

	<div class="page" id="register-page">

		<form action="" name="signup_form" id="signup_form" class="standard-form" method="post" enctype="multipart/form-data">

		<?php if ( 'registration-disabled' == bp_get_current_signup_step() ) : ?>

			<div id="template-notices" role="alert" aria-atomic="true">
				<?php

				/** This action is documented in bp-templates/bp-legacy/buddypress/activity/index.php */
				do_action( 'template_notices' ); ?>

			</div>

			<?php

			/**
			 * Fires before the display of the registration disabled message.
			 *
			 * @since 1.5.0
			 */
			do_action( 'bp_before_registration_disabled' ); ?>

			<p><?php _e( 'User registration is currently not allowed.', 'buddypress' ); ?></p>

			<?php

			/**
			 * Fires after the display of the registration disabled message.
			 *
			 * @since 1.5.0
			 */
			do_action( 'bp_after_registration_disabled' ); ?>
		<?php endif; // registration-disabled signup step ?>

		<?php if ( 'request-details' == bp_get_current_signup_step() ) : ?>

			<div id="template-notices" role="alert" aria-atomic="true">
				<?php
				
				/** This action is documented in bp-templates/bp-legacy/buddypress/activity/index.php */
				do_action( 'template_notices' ); ?>

			</div>

			<p><?php _e( 'Registering for this site is easy. Just fill in the fields below, and we\'ll get a new account set up for you in no time.', 'buddypress' ); ?></p>

			
				<div class="row">
					
					<div class="col-sm-12">

						<?php

						/**
						 * Fires before the display of member registration account details fields.
						 *
						 * @since 1.1.0
						 */
						do_action( 'bp_before_account_details_fields' ); ?>

						<div class="register-section" id="basic-details-section">

						<?php /***** Basic Account Details ******/ ?>

						<h4><?php _e( 'Account Details', 'buddypress' ); ?></h4>

						<label for="signup_username"><?php _e( 'Username', 'buddypress' ); ?> <?php _e( '(required)', 'buddypress' ); ?></label>
						<?php

						/**
						 * Fires and displays any member registration username errors.
						 *
						 * @since 1.1.0
						 */
						do_action( 'bp_signup_username_errors' ); ?>                
						<input type="text" name="signup_username" id="signup_username" value="<?php bp_signup_username_value(); ?>" <?php bp_form_field_attributes( 'username' ); ?>/>

						<label for="signup_email"><?php _e( 'Email Address', 'buddypress' ); ?> <?php _e( '(required)', 'buddypress' ); ?></label>
						<?php
						
						/**
						 * Fires and displays any member registration email errors.
						 *
						 * @since 1.1.0
						 */
						do_action( 'bp_signup_email_errors' ); ?>
						<input type="email" name="signup_email" id="signup_email" value="<?php bp_signup_email_value(); ?>" <?php bp_form_field_attributes( 'email' ); ?>/>

						<label for="signup_password"><?php _e( 'Choose a Password', 'buddypress' ); ?> <?php _e( '(required)', 'buddypress' ); ?></label>
						<?php
						
						/**
						 * Fires and displays any member registration password errors.
						 *
						 * @since 1.1.0
						 */
						do_action( 'bp_signup_password_errors' ); ?>
						<input type="password" name="signup_password" id="signup_password" value="" class="password-entry" <?php bp_form_field_attributes( 'password' ); ?>/>
                        <div id="pass-strength-result"></div>

						<label for="signup_password_confirm"><?php _e( 'Confirm Password', 'buddypress' ); ?> <?php _e( '(required)', 'buddypress' ); ?></label>
						<?php
						
						/**
						 * Fires and displays any member registration password confirmation errors.
						 *
						 * @since 1.1.0
						 */
						do_action( 'bp_signup_password_confirm_errors' ); ?>
						<input type="password" name="signup_password_confirm" id="signup_password_confirm" value="" class="password-entry-confirm" <?php bp_form_field_attributes( 'password' ); ?>/>

						<?php

						/**
						 * Fires and displays any extra member registration details fields.
						 *
						 * @since 1.9.0
						 */
						do_action( 'bp_account_details_fields' ); ?>

					</div><!-- #basic-details-section -->

						<?php

						/**
						 * Fires after the display of member registration account details fields.
						 *
						 * @since 1.1.0
						 */
						do_action( 'bp_after_account_details_fields' ); ?>
				<!-- </div>
				<div class="col-sm-6"> -->

					<?php /***** Extra Profile Details ******/ ?>

					<?php if ( bp_is_active( 'xprofile' ) ) : ?>

						<?php

						/**
						 * Fires before the display of member registration xprofile fields.
						 *
						 * @since 1.2.4
						 */
						do_action( 'bp_before_signup_profile_fields' ); ?>

						<div class="register-section" id="profile-details-section">

							<h4><?php _e( 'Profile Details', 'buddypress' ); ?></h4>

							<?php /* Use the profile field loop to render input fields for the 'base' profile field group */ ?>
							<?php if ( bp_is_active( 'xprofile' ) ) : if ( bp_has_profile( array( 'profile_group_id' => 1, 'fetch_field_data' => false ) ) ) : while ( bp_profile_groups() ) : bp_the_profile_group(); ?>

							<?php while ( bp_profile_fields() ) : bp_the_profile_field(); ?>

                                <div<?php bp_field_css_class( 'editfield' ); ?>>
									<fieldset>

									<?php
									$field_type = bp_xprofile_create_field_type( bp_get_the_profile_field_type() );
									$field_type->edit_field_html();

									/**
									 * Fires before the display of the visibility options for xprofile fields.
									 *
									 * @since 1.7.0
									 */
									do_action( 'bp_custom_profile_edit_fields_pre_visibility' );

									if ( bp_current_user_can( 'bp_xprofile_change_field_visibility' ) ) : ?>
										<p class="field-visibility-settings-toggle" id="field-visibility-settings-toggle-<?php bp_the_profile_field_id() ?>"><span id="<?php bp_the_profile_field_input_name(); ?>-2">
											<?php
											printf(
												__( 'This field can be seen by: %s', 'buddypress' ),
												'<span class="current-visibility-level">' . bp_get_the_profile_field_visibility_level_label() . '</span>'
											);
											?>
											</span>
											<a href="#" class="visibility-toggle-link" aria-describedby="<?php bp_the_profile_field_input_name(); ?>-2" aria-expanded="false"><?php _ex( 'Change', 'Change profile field visibility level', 'buddypress' ); ?></a>
										</p>

										<div class="field-visibility-settings" id="field-visibility-settings-<?php bp_the_profile_field_id() ?>">
											<fieldset>
												<legend><?php _e( 'Who can see this field?', 'buddypress' ) ?></legend>

												<?php bp_profile_visibility_radio_buttons() ?>

											</fieldset>
											<a class="field-visibility-settings-close" href="#"><?php _e( 'Close', 'buddypress' ) ?></a>

										</div>
									<?php else : ?>
										<p class="field-visibility-settings-notoggle" id="field-visibility-settings-toggle-<?php bp_the_profile_field_id() ?>">
											<?php
											printf(
												__( 'This field can be seen by: %s', 'buddypress' ),
												'<span class="current-visibility-level">' . bp_get_the_profile_field_visibility_level_label() . '</span>'
											);
											?>
										</p>
									<?php endif ?>

	                                <?php

	                                /**
	                                 * Fires after the display of the visibility options for xprofile fields.
	                                 *
	                                 * @since 1.1.0
	                                 */
	                                do_action( 'bp_custom_profile_edit_fields' ); ?>

									</fieldset>

									

									<!-- Custom Changes for Autocomplete by Suman START -->

									

									<!-- Custom Changes for Autocomplete by Suman END -->


								</div>

							<?php endwhile; ?>


							<input type="hidden" name="signup_profile_field_ids" id="signup_profile_field_ids" value="<?php bp_the_profile_field_ids(); ?>" />

							<?php endwhile; endif; endif; ?>
							
							<?php 
										$selct_nmes = $wpdb->get_results("SELECT `name` FROM `etooe_salesforce_accounts` WHERE 1");
										// $comp_nme = json_encode($selct_nmes);
										// echo "<pre>";
										// print_r($selct_nmes->Name);
										// exit();

										foreach ($selct_nmes as $selct_nme) {
											$comp_nme = $selct_nme->name;
											// echo '"'.$comp_nme.'",';
											$comp_nmet .= '"'.$comp_nme.'",';
											
											// $selct_ides = $wpdb->get_results("SELECT `account_18_digit_id__c` FROM `etooe_salesforce_accounts` WHERE `name` = $comp_nme");
											// echo $selct_ides.', ';
											// exit();

											
										}
										$comp_nmett = '['.rtrim($comp_nmet,',').']';
										// echo $comp_nmett;
										// exit();
									?>
									<script type="text/javascript">
																				
										// var companiess = ["ICBC","China Construction Bank","JPMorgan Chase","Berkshire Hathaway","Agricultural Bank of China","	Bank of America","Wells Fargo","Apple","Bank of China","Ping An Insurance Group","Royal Dutch Shell","Toyota Motor","ExxonMobil","Samsung Electronics","AT&T","Volkswagen Group","HSBC Holdings","Verizon Communications","BNP Paribas","Microsoft","Chevron","Allianz","Alphabet","Walmart","China Mobile","Total","Sinopec","UnitedHealth Group","Daimler","PetroChina","Banco Santander","China Merchants Bank","AXA Group","Comcast","China Life Insurance","BP","Cayman Islands","Central Arfrican Republic","Chad","Chile","China","Colombia","Congo","Cook Islands","Costa Rica","Cote D Ivoire","Croatia","Cuba","Curacao","Cyprus","Czech Republic","Denmark","Djibouti","Dominica","Dominican Republic","Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Ethiopia","Falkland Islands","Faroe Islands","Fiji","Finland","France","French Polynesia","French West Indies","Gabon","Gambia","Georgia","Germany","Ghana","Gibraltar","Greece","Greenland","Grenada","Guam","Guatemala","Guernsey","Guinea","Guinea Bissau","Guyana","Haiti","Honduras","Hong Kong","Hungary","Iceland","India","Indonesia","Iran","Iraq","Ireland","Isle of Man","Israel","Italy","Jamaica","Japan","Jersey","Jordan","Kazakhstan","Kenya","Kiribati","Kosovo","Kuwait","Kyrgyzstan","Laos","Latvia","Lebanon","Lesotho","Liberia","Libya","Liechtenstein","Lithuania","Luxembourg","Macau","Macedonia","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Mauritania","Mauritius","Mexico","Micronesia","Moldova","Monaco","Mongolia","Montenegro","Montserrat","Morocco","Mozambique","Myanmar","Namibia","Nauro","Nepal","Netherlands","Netherlands Antilles","New Caledonia","New Zealand","Nicaragua","Niger","Nigeria","North Korea","Norway","Oman","Pakistan","Palau","Palestine","Panama","Papua New Guinea","Paraguay","Peru","Philippines","Poland","Portugal","Puerto Rico","Qatar","Reunion","Romania","Russia","Rwanda","Saint Pierre & Miquelon","Samoa","San Marino","Sao Tome and Principe","Saudi Arabia","Senegal","Serbia","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Solomon Islands","Somalia","South Africa","South Korea","South Sudan","Spain","Sri Lanka","St Kitts & Nevis","St Lucia","St Vincent","Sudan","Suriname","Swaziland","Sweden","Switzerland","Syria","Taiwan","Tajikistan","Tanzania","Thailand","Timor L'Este","Togo","Tonga","Trinidad & Tobago","Tunisia","Turkey","Turkmenistan","Turks & Caicos","Tuvalu","Uganda","Ukraine","United Arab Emirates","United Kingdom","United States of America","Uruguay","Uzbekistan","Vanuatu","Vatican City","Venezuela","Vietnam","Virgin Islands (US)","Yemen","Zambia","Zimbabwe"];

										$(function () {
											var companiess = <?php echo $comp_nmett; ?>;
											var comapny_nm = '';

										// var companiess = "<?php print_r($comp_nme); ?>";
										// alert(companiess);

										    
										    $("#field_167").autocomplete({
										        source: companiess
										    });

										    $('#field_167').on('autocompletechange', function () {
										        /* $('#tagsname').html('You selected: ' + this.value); */
										        var comapny_nm = this.value;
										        //alert(comapny_nm);
											    $.post( "https://beta.techshu.org/CMS/E2E/wp-content/themes/kleo/check.php", {abc : comapny_nm}, function( data ) {
											    	//alert(data);
												  	$( "#field_291" ).val( data );
												});
										    });
										  
										    
										});
										//autocomplete(document.getElementById("field_167"), companiess);

										// $('#field_167').on('select', function() {
										//   	alert( this.value );
										// });
										
										// $(document).ready(function () {
										//     $('#field_167').on('autocompletechange', function () {
										//          $('#tagsname').html('You selected: ' + this.value); 
										//         alert(this.value);
										//     });
										// });

										// var alr = document.getElementById('field_167').value;
										// alert (alr);
										
									</script>


							<?php
								
								

							/**
							 * Fires and displays any extra member registration xprofile fields.
							 *
							 * @since 1.9.0
							 */
							do_action( 'bp_signup_profile_fields' ); ?>

						</div><!-- #profile-details-section -->

						<?php

						/**
						 * Fires after the display of member registration xprofile fields.
						 *
						 * @since 1.1.0
						 */
						do_action( 'bp_after_signup_profile_fields' ); ?>

					<?php endif; ?>
				
				</div>
			</div>

			<?php if ( bp_get_blog_signup_allowed() ) : ?>

				<?php

				/**
				 * Fires before the display of member registration blog details fields.
				 *
				 * @since 1.1.0
				 */
				do_action( 'bp_before_blog_details_fields' ); ?>

				<?php /***** Blog Creation Details ******/ ?>

				<div class="register-section" id="blog-details-section">

					<h4><?php _e( 'Blog Details', 'buddypress' ); ?></h4>

					<p><input type="checkbox" name="signup_with_blog" id="signup_with_blog" value="1"<?php if ( (int) bp_get_signup_with_blog_value() ) : ?> checked="checked"<?php endif; ?> /> <?php _e( 'Yes, I\'d like to create a new site', 'buddypress' ); ?></p>

					<div id="blog-details"<?php if ( (int) bp_get_signup_with_blog_value() ) : ?>class="show"<?php endif; ?>>

						<label for="signup_blog_url"><?php _e( 'Blog URL', 'buddypress' ); ?> <?php _e( '(required)', 'buddypress' ); ?></label>
						<?php
						
						/**
						 * Fires and displays any member registration blog URL errors.
						 *
						 * @since 1.1.0
						 */
						do_action( 'bp_signup_blog_url_errors' ); ?>

						<?php if ( is_subdomain_install() ) : ?>
							http:// <input type="text" name="signup_blog_url" id="signup_blog_url" value="<?php bp_signup_blog_url_value(); ?>" /> .<?php bp_signup_subdomain_base(); ?>
						<?php else : ?>
							<?php echo home_url( '/' ); ?> <input type="text" name="signup_blog_url" id="signup_blog_url" value="<?php bp_signup_blog_url_value(); ?>" />
						<?php endif; ?>

						<label for="signup_blog_title"><?php _e( 'Site Title', 'buddypress' ); ?> <?php _e( '(required)', 'buddypress' ); ?></label>
						<?php
						
						/**
						 * Fires and displays any member registration blog title errors.
						 *
						 * @since 1.1.0
						 */
						do_action( 'bp_signup_blog_title_errors' ); ?>
						<input type="text" name="signup_blog_title" id="signup_blog_title" value="<?php bp_signup_blog_title_value(); ?>" />

						<fieldset class="register-site">
							<span class="label"><?php _e( 'Privacy: I would like my site to appear in search engines, and in public listings around this network.', 'buddypress' ); ?>:</span>
							<?php
							
							/**
							 * Fires and displays any member registration blog privacy errors.
							 *
							 * @since 1.1.0
							 */
							do_action( 'bp_signup_blog_privacy_errors' ); ?>
	
							<label for="signup_blog_privacy_public"><input type="radio" name="signup_blog_privacy" id="signup_blog_privacy_public" value="public"<?php if ( 'public' == bp_get_signup_blog_privacy_value() || !bp_get_signup_blog_privacy_value() ) : ?> checked="checked"<?php endif; ?> /> <?php _e( 'Yes', 'buddypress' ); ?></label>
							<label for="signup_blog_privacy_private"><input type="radio" name="signup_blog_privacy" id="signup_blog_privacy_private" value="private"<?php if ( 'private' == bp_get_signup_blog_privacy_value() ) : ?> checked="checked"<?php endif; ?> /> <?php _e( 'No', 'buddypress' ); ?></label>
						</fieldset>
						
						<?php
						
						/**
						 * Fires and displays any extra member registration blog details fields.
						 *
						 * @since 1.9.0
						 */
						do_action( 'bp_blog_details_fields' ); ?>

					</div>

				</div><!-- #blog-details-section -->
				
				<?php
				
				/**
				 * Fires after the display of member registration blog details fields.
				 *
				 * @since 1.1.0
				 */
				do_action( 'bp_after_blog_details_fields' ); ?>

			<?php endif; ?>
			
			<?php
			
			/**
			 * Fires before the display of the registration submit buttons.
			 *
			 * @since 1.1.0
			 */
			do_action( 'bp_before_registration_submit_buttons' ); ?>
			
			<p>By filling up this form you are applying for a membership. You will receive an email with a link to verify your email ID also you account will be activated once we have reviewed your details for eligibility.</p>

			<div class="submit">
				<input type="submit" name="signup_submit" id="signup_submit" value="<?php esc_attr_e( 'Complete Sign Up', 'buddypress' ); ?>" />
			</div>
			
			<?php
			
			/**
			 * Fires after the display of the registration submit buttons.
			 *
			 * @since 1.1.0
			 */
			do_action( 'bp_after_registration_submit_buttons' ); ?>

			<?php wp_nonce_field( 'bp_new_signup' ); ?>

		<?php endif; // request-details signup step ?>

		<?php if ( 'completed-confirmation' == bp_get_current_signup_step() ) : ?>

			<div id="template-notices" role="alert" aria-atomic="true">
				<?php
				
				/** This action is documented in bp-templates/bp-legacy/buddypress/activity/index.php */
				do_action( 'template_notices' ); ?>

			</div>
			
			<?php
			
			/**
			 * Fires before the display of the registration confirmed messages.
			 *
			 * @since 1.5.0
			 */
			do_action( 'bp_before_registration_confirmed' ); ?>

			<div id="template-notices" role="alert" aria-atomic="true">
				<?php if ( bp_registration_needs_activation() ) : ?>
					<p><?php _e( 'You have successfully created your account! To begin using this site you will need to activate your account via the email we have just sent to your address.', 'buddypress' ); ?></p>
				<?php else : ?>
					<p><?php _e( 'You have successfully created your account! Please log in using the username and password you have just created.', 'buddypress' ); ?></p>
				<?php endif; ?>
			</div>
			
			<?php
			
			/**
			 * Fires after the display of the registration confirmed messages.
			 *
			 * @since 1.5.0
			 */
			do_action( 'bp_after_registration_confirmed' ); ?>

		<?php endif; // completed-confirmation signup step ?>
			
			<?php
			
			/**
			 * Fires and displays any custom signup steps.
			 *
			 * @since 1.1.0
			 */
			do_action( 'bp_custom_signup_steps' ); ?>

		</form>

	</div>
	
	<?php
	
	/**
	 * Fires at the bottom of the BuddyPress member registration page template.
	 *
	 * @since 1.1.0
	 */
	do_action( 'bp_after_register_page' ); ?>

</div><!-- #buddypress -->
