# Import & Export

Some of the data used by this plugin - namely, Fieldmaps, Object Maps, and Plugin Settings - can be imported (from a .json file) and exported (to a .json file).

While this feature is mostly intended for developers at this time, non-developers will possibly find it useful, for example to back up plugin data.

You can use this feature from the Import &amp; Export tab in the plugin's settings.

## Importing

When importing, you need a .json file that has been created by this plugin's export feature, or by hand to match its format.

Once you have one, any data that you can export (defined below) can also be imported. If you check the Overwrite existing data checkbox, any matching data will be overwritten.

Using this feature should not be risky to your WordPress install in general, but you should always back up your database before doing something like this. Especially if any part of this plugin is already working, as this could be affected by the import.

If you intend to do any hand coding of JSON for importing, you should export the JSON first, with as much configuration as possible, so you can see how it is formatted. Much of the data that gets stored in the JSON is autogenerated based on responses from the Salesforce API, while other parts are stored as you go through the process of setting up the plugin.

## Exporting

When exporting, you can include any or all of the following data:

- Fieldmaps: this will include all of the data that matches a WordPress object to a Salesforce object.
- Object Maps: this will include all of the individual maps between WordPress and Salesforce data records.
- Plugin Settings: this is the plugin's settings. You probably don't want to make this public, since it may contain Salesforce API keys.
