<?php

/*
Plugin Name: Data Scrapping Tool
Plugin URI: https://www.e2exchange.org
Description: This is to manage, add, delete, approve companies
Version: 1.0
Author: Prabhanjan Panigrahi
Author URI:  https://www.techshu.com
*/
/*ini_set('log_errors','On');
ini_set('display_errors','Off');
ini_set('error_reporting', E_ALL );
define('WP_DEBUG', false);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);*/

if ( ! class_exists( 'WP_List_Table' ) ) {
	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class DST_List extends WP_List_Table {

	/** Class constructor */
	public function __construct() {

		parent::__construct( [
			'singular' => __( 'Company', 'dst' ), //singular name of the listed records
			'plural'   => __( 'companies', 'dst' ), //plural name of the listed records
			'ajax'     => false //does this table support ajax?
		] );

	}

	/**
	 * Retrieve companies data from the database
	 *
	 * @param int $per_page
	 * @param int $page_number
	 *
	 * @return mixed
	 */
	public static function get_companies( $per_page = 50, $page_number = 1 ) {

		global $wpdb;

/*		$sql = "SELECT * FROM {$wpdb->prefix}companies";*/
		$sql = "SELECT * FROM `company_data_master`";

		if ( ! empty( $_REQUEST['orderby'] ) ) {
			$sql .= ' ORDER BY ' . esc_sql( $_REQUEST['orderby'] );
			$sql .= ! empty( $_REQUEST['order'] ) ? ' ' . esc_sql( $_REQUEST['order'] ) : ' ASC';
		}

		$sql .= " LIMIT $per_page";
		$sql .= ' OFFSET ' . ( $page_number - 1 ) * $per_page;


		$result = $wpdb->get_results( $sql,'ARRAY_A');
		foreach ($result  as $key => $value) {
			$result[$key]['post_id'] = self::get_postID( $value['reg_company_number'] );
		}
		return $result;
	}



	public static function get_postID( $reg_company_number ) {

		global $wpdb;

/*		$sql = "SELECT * FROM {$wpdb->prefix}companies";*/
		$sql = "SELECT max(`meta_id`), `post_id`, `meta_value` FROM `mcl_postmeta` WHERE `meta_key` LIKE 'reg_company_number' AND `meta_value` LIKE {$reg_company_number}";


		$result = $wpdb->get_row( $sql,'ARRAY_A');
		return $result['post_id'];
	}



	/**
	 * Delete a company record.
	 *
	 * @param int $id company ID
	 */
	public static function delete_company( $id ) {
		global $wpdb;

		$wpdb->delete(
			"company_data_master",
			[ 'ID' => $id ],
			[ '%d' ]
		);
	}


	/**
	 * Returns the count of records in the database.
	 *
	 * @return null|string
	 */
	public static function record_count() {
		global $wpdb;

		$sql = "SELECT COUNT(*) FROM company_data_master";

		return $wpdb->get_var( $sql );
	}


	/** Text displayed when no company data is available */
	public function no_items() {
		_e( 'No companies avaliable.', 'dst' );
	}


	/**
	 * Render a column when no column specific method exist.
	 *
	 * @param array $item
	 * @param string $column_name
	 *
	 * @return mixed
	 */
	public function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'company_name':
			case 'total_income':
			case 'post_id':
			case 'total_spending':
			case 'reg_company_number':
			case 'status':
				return $item[ $column_name ];
			default:
				return print_r( $item, true ); //Show the whole array for troubleshooting purposes
		}
	}

	/**
	 * Render the bulk edit checkbox
	 *
	 * @param array $item
	 *
	 * @return string
	 */
	function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="bulk-delete[]" value="%s" />', $item['ID']
		);
	}


	/**
	 * Method for name column
	 *
	 * @param array $item an array of DB data
	 *
	 * @return string
	 */
	function column_name( $item ) {

		$delete_nonce = wp_create_nonce( 'mcl_delete_company' );

		$title = '<strong>' . $item['company_name'] . '</strong>';

		$actions = [
			'delete' => sprintf( '<a href="?page=%s&action=%s&company=%s&_wpnonce=%s">Delete</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['ID'] ), $delete_nonce )
		];

		return $title . $this->row_actions( $actions );
	}


	/**
	 *  Associative array of columns
	 *
	 * @return array
	 */
	function get_columns() {
		$columns = [
			'cb'      => '<input type="checkbox" />',
			'company_name'    => __( 'Name', 'dst' ),
			'post_id' => __( 'Post ID', 'dst' ),
			'reg_company_number' => __( 'Company Number', 'dst' ),
			'total_income'    => __( 'Total Income', 'dst' ),
			'total_spending'    => __( 'Total Spending', 'dst' ),
			'status'    => __( 'Status', 'dst' )
		];

		return $columns;
	}


	/**
	 * Columns to make sortable.
	 *
	 * @return array
	 */
	public function get_sortable_columns() {
		$sortable_columns = array(
			'company_name' => array( 'company_name', true ),
			'status' => array( 'status', false ),
			'total_spending' => array( 'total_spending', false ),
			'total_income' => array( 'total_income', false )
		);

		return $sortable_columns;
	}

	/**
	 * Returns an associative array containing the bulk action
	 *
	 * @return array
	 */
	public function get_bulk_actions() {
		$actions = [
			'bulk-delete' => 'Delete'
		];

		return $actions;
	}


	/**
	 * Handles data query and filter, sorting, and pagination.
	 */
	public function prepare_items() {

		$this->_column_headers = $this->get_column_info();

		/** Process bulk action */
		$this->process_bulk_action();

		$per_page     = $this->get_items_per_page( 'companies_per_page', 50 );
		$current_page = $this->get_pagenum();
		$total_items  = self::record_count();

		$this->set_pagination_args( [
			'total_items' => $total_items, //WE have to calculate the total number of items
			'per_page'    => $per_page //WE have to determine how many items to show on a page
		] );

		$this->items = self::get_companies( $per_page, $current_page );
	}

	public function process_bulk_action() {

		//Detect when a bulk action is being triggered...
		if ( 'delete' === $this->current_action() ) {

			// In our file that handles the request, verify the nonce.
			$nonce = esc_attr( $_REQUEST['_wpnonce'] );

			if ( ! wp_verify_nonce( $nonce, 'mcl_delete_company' ) ) {
				die( 'Go get a life script kiddies' );
			}
			else {
				self::delete_company( absint( $_GET['company'] ) );

		                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"
		                // add_query_arg() return the current url
		                wp_redirect( esc_url_raw(add_query_arg()) );
				exit;
			}

		}

		// If the delete bulk action is triggered
		if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-delete' )
		     || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-delete' )
		) {

			$delete_ids = esc_sql( $_POST['bulk-delete'] );

			// loop over the array of record IDs and delete them
			foreach ( $delete_ids as $id ) {
				self::delete_company( $id );

			}

			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
		        // add_query_arg() return the current url
		        wp_redirect( esc_url_raw(add_query_arg()) );
			exit;
		}
	}

}


class DST_Plugin {

	// class instance
	static $instance;

	// company WP_List_Table object
	public $companies_obj;

	// class constructor
	public function __construct() {
		add_filter( 'set-screen-option', [ __CLASS__, 'set_screen' ], 10, 3 );
		add_action( 'admin_menu', [ $this, 'plugin_menu' ] );
	}


	public static function set_screen( $status, $option, $value ) {
		return $value;
	}

	public function plugin_menu() {

		$hook = add_menu_page(
			'Manage Company Data',
			'Manage Company Data',
			'manage_options',
			'manage_companies',
			[ $this, 'plugin_settings_page' ]
		);

		add_action( "load-$hook", [ $this, 'screen_option' ] );

	}

public function plugin_settings_page() {
	$action = isset($_GET['action'])? $_GET['action']: '';
	switch($action )
	{
		case 'add':
			$this->plugin_add_company_page();
			break;		
		case 'pending':
			$this->plugin_company_listing_pending_page();
			break;
		case 'flush-cache':
			$this->plugin_fush_cache_company_page();
			break;
		default:
			$this->plugin_company_listing_page();
	}
}

	/**
	 * Plugin settings page
	 */
	public function plugin_company_listing_page() {
		?>
		<div class="wrap">
		<h1 class="wp-heading-inline">Company List</h1>

		 <a href="admin.php?page=manage_companies&action=add" class="page-title-action">Add New</a>
		  <a href="admin.php?page=manage_companies&action=flush-cache"" class="page-title-action">Flush Cache</a>
		<hr class="wp-header-end">

		<h2 class='screen-reader-text'>Filter pages list</h2><ul class='subsubsub'>
			<li class='all'><a href="admin.php?page=manage_companies" class="current" aria-current="page">All <span class="count">(<?php echo $this->companies_obj->record_count(); ?>)</span></a> |</li>
			<li class='publish'><a href="admin.php?page=manage_companies&action=">Pending <span class="count">(6)</span></a></li> 
		</ul>
			<div id="poststuff">
				<div id="post-body" class="metabox-holder columns-2">
					<div id="post-body-content">
						<div class="meta-box-sortables ui-sortable">
							<form method="post">
								<?php
								$this->companies_obj->prepare_items();
								$this->companies_obj->display(); ?>
							</form>
						</div>
					</div>
				</div>
				<br class="clear">
			</div>
		</div>
	<?php
	}

	/**
	 * Plugin settings page
	 */
	public function plugin_company_listing_pending_page() {
		?>
		<div class="wrap">
<h1 class="wp-heading-inline">Company List</h1>

 <a href="admin.php?page=manage_companies&action=add" class="page-title-action">Add New</a>
  <a href="admin.php?page=manage_companies&action=flush-cache"" class="page-title-action">Flush Cache</a>
<hr class="wp-header-end">


<h2 class='screen-reader-text'>Filter pages list</h2><ul class='subsubsub'>
	<li class='all'><a href="admin.php?page=manage_companies" class="current" aria-current="page">All <span class="count">(<?php echo $this->companies_obj->record_count(); ?>)</span></a> |</li>
	<li class='publish'><a href="admin.php?page=manage_companies&action=pending">Pending <span class="count">(6)</span></a></li> 
</ul>
			<div id="poststuff">
				<div id="post-body" class="metabox-holder columns-2">
					<div id="post-body-content">
						<div class="meta-box-sortables ui-sortable">
							<form method="post">
								<?php
								$this->companies_obj->prepare_items();
								$this->companies_obj->display(); ?>
							</form>
						</div>
					</div>
				</div>
				<br class="clear">
			</div>
		</div>
	<?php
	}	

	/**
	 * Plugin Add Company page
	 */
	public function plugin_add_company_page() {
		?>
		<div class="wrap">
<h1 class="wp-heading-inline">Company List</h1>

 <a href="admin.php?page=manage_companies&action=add"" class="page-title-action">Add New</a>
  <a href="admin.php?page=manage_companies&action=flush-cache"" class="page-title-action">Flush Cache</a>
<hr class="wp-header-end">


<h2 class='screen-reader-text'>Filter pages list</h2><ul class='subsubsub'>
	<li class='all'><a href="admin.php?page=manage_companies" class="current" aria-current="page">All <span class="count">(<?php echo $this->companies_obj->record_count(); ?>)</span></a> |</li>
<!-- 	<li class='publish'><a href="admin.php?page=manage_companies">Active <span class="count">(6)</span></a></li> -->
</ul>
			<div id="poststuff">
				<div id="post-body" class="metabox-holder columns-2">
					<div id="post-body-content">
						<div class="meta-box-sortables ui-sortable">
							<?php
include "includes/companies-fulldata.php";
							 displayDataTable(); ?>
							<form method="get" action="admin.php?page=manage_companies&action=add">
								Company registration ID:
								<input type="hidden" name="page" value="manage_companies"/>
								<input type="hidden" name="action" value="add"/>
								<input type="text" name="company_id" value="<?php echo $_GET['company_id']; ?>" />
								<br/>
								Linkedin URL:
								<input type="text" name="linkedin_url" value="<?php echo $_GET['linkedin_url']; ?>" />
								<input type="submit" />
							</form>
							<?php
							if(isset($_GET['company_id']))
							{

								include "includes/companies-fulldata.php";
								if(isset($_GET['approve']) && $_GET['approve'] == 'on')
								{
									addData($_GET['company_id']);
								}else{
									//displayData($_GET['company_id'],$_GET['linkedin_url']);
									displayDataTable();
								}
								
							}
							?>
						</div>
					</div>
				</div>
				<br class="clear">
			</div>
		</div>
	<?php
	}
	/**
	 * Plugin Add Company page
	 */
	public function plugin_fush_cache_company_page() {
		?>
		<div class="wrap">
<h1 class="wp-heading-inline">Company List</h1>

 <a href="admin.php?page=manage_companies&action=add"" class="page-title-action">Add New</a>
 <a href="admin.php?page=manage_companies&action=flush-cache"" class="page-title-action">Flush Cache</a>
<hr class="wp-header-end">


<h2 class='screen-reader-text'>Filter pages list</h2><ul class='subsubsub'>
	<li class='all'><a href="admin.php?page=manage_companies" class="current" aria-current="page">All <span class="count">(<?php echo $this->companies_obj->record_count(); ?>)</span></a> |</li>
<!-- 	<li class='publish'><a href="admin.php?page=manage_companies">Active <span class="count">(6)</span></a></li> -->
</ul>
			<div id="poststuff">
				<div id="post-body" class="metabox-holder columns-2">
					<div id="post-body-content">
						<div class="meta-box-sortables ui-sortable">
							<?php

								include "includes/flush-cache.php";
								flush_company_cache();
								echo "Cache Updated";

							?>
						</div>
					</div>
				</div>
				<br class="clear">
			</div>
		</div>
	<?php
	}

	/**
	 * Screen options
	 */
	public function screen_option() {

		$option = 'per_page';
		$args   = [
			'label'   => 'companies',
			'default' => 5,
			'option'  => 'companies_per_page'
		];

		add_screen_option( $option, $args );

		$this->companies_obj = new DST_List();
	}


	/** Singleton instance */
	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

}


add_action( 'plugins_loaded', function () {
	DST_Plugin::get_instance();
} );
