<?php
/**
 * @package SalesAccountSyncPlugin
 */
/*
  Plugin Name: Sales Account Sync Plugin
  Plugin URI: http://beta.techshu.org/CMS/E2E/
  Description: Syncs salesforce data with wordpress website
  Version: 1.0.0
  Author: Sandeep Tewary
  Author URI: http://beta.techshu.org/CMS/E2E/
  License: GPLv2+
  Text Domain: sales-account-sync
*/

add_action('admin_menu', 'sales_account_sync_setup_menu');

add_option( 'salesforce_sync_client_id', '', '', 'yes' );

add_option( 'salesforce_sync_client_secret', '', '', 'yes' );

//add_option( 'salesforce_sync_callback_url', '', '', 'yes' );
 
function sales_account_sync_setup_menu(){
        add_menu_page( 'Sales Account Sync Plugin', 'SalesForce Sync', 'manage_options', 'sales-account-sync', 'page_body' );
}
// Define our State class
class State 
{
    public $passthroughState1;  // Arbitary state we want to pass to the Authentication request
    public $passthroughState2;  // Arbitary state we want to pass to the Authentication request

    public $code;               // Authentication code received from Salesforce
    public $token;              // Session token
    public $refreshToken;       // Refresh token
    public $instanceURL;        // Salesforce Instance URL
    public $userId;             // Current User Id
     
    public $codeVerifier;       // 128 bytes of random data used to secure the request

    public $error;              // Error code
    public $errorDescription;   // Error description

    /**
     * Constructor - Takes 2 pieces of optional state we want to preserve through the request
     */
    function __construct($state1 = "", $state2 = "")
    {
        // Initialise arbitary state
        $this->passthroughState1 = $state1;
        $this->passthroughState2 = $state2;

        // Initialise remaining state
        $this->code = "";
        $this->token = "";
        $this->refreshToken = "";
        $this->instanceURL = "";
        $this->userId = "";
         
        $this->error = "";
        $this->errorDescription = "";

        // Generate 128 bytes of random data
        $this->codeVerifier = bin2hex(openssl_random_pseudo_bytes(128));
    }

    /**
     * Helper function to populate state following a call back from Salesforce
     */
    function loadStateFromRequest()
    {
        $stateString = "";

        // If we've arrived via a GET request, we can assume it's a callback from Salesforce OAUTH
        // so attempt to load the state from the parameters in the request
        if ($_SERVER["REQUEST_METHOD"] == "GET") 
        {
            $this->code = $this->sanitizeInput($_GET["code"]);
            $this->error = $this->sanitizeInput($_GET["error"]);
            $this->errorDescription = $this->sanitizeInput($_GET["error_description"]);
            $stateString = $this->sanitizeInput($_GET["state"]);

            // If we have a state string, then deserialize this into state as it's been passed
            // to the salesforce request and back
            if ($stateString)
            {
                $this->deserializeStateString($stateString);
            }
        }
    }

    /**
     * Helper function to sanitize any input and prevent injection attacks
     */
    function sanitizeInput($data) 
    {
        $data = trim($data);
        $data = stripslashes($data);
        $data = htmlspecialchars($data);
        return $data;
    }

    /**
     * Helper function to serialize our arbitary state we want to send accross the request
     */
    function serializeStateString()
    {
        $stateArray = array("passthroughState1" => $this->passthroughState1, 
                            "passthroughState2" => $this->passthroughState2
                            );

        return rawurlencode(base64_encode(serialize($stateArray)));
    }

    /**
     * Helper function to deserialize our arbitary state passed back in the callback
     */
    function deserializeStateString($stateString)
    {
        $stateArray = unserialize(base64_decode(rawurldecode($stateString)));

        $this->passthroughState1 = $stateArray["passthroughState1"];
        $this->passthroughState2 = $stateArray["passthroughState2"];
    }

    /**
     * Helper function to generate the code challenge for the code verifier
     */
    function generateCodeChallenge()
    {
        $hash = pack('H*', hash("SHA256", $this->generateCodeVerifier()));

        return $this->base64url_encode($hash);
    }

    /**
     * Helper function to generate the code verifier
     */
    function generateCodeVerifier()
    {
        return $this->base64url_encode(pack('H*', $this->codeVerifier));
    }

    /**
     * Helper function to Base64URL encode as per https://tools.ietf.org/html/rfc4648#section-5
     */
    function base64url_encode($string)
    {
        return strtr(rtrim(base64_encode($string), '='), '+/', '-_');
    }

    /**
     * Helper function to display the current state values
     */
    function debugState($message = NULL)
    {
        if ($message != NULL)
        {
            echo "<pre>$message</pre>";
        }

        echo "<pre>passthroughState1 = $this->passthroughState1</pre>";
        echo "<pre>passthroughState2 = $this->passthroughState2</pre>";
        echo "<pre>code = $this->code</pre>";
        echo "<pre>token = $this->token</pre>";
        echo "<pre>refreshToken = $this->refreshToken</pre>";
        echo "<pre>instanceURL = $this->instanceURL</pre>";
        echo "<pre>userId = $this->userId</pre>";
        echo "<pre>error = $this->error</pre>";
        echo "<pre>errorDescription = $this->errorDescription</pre>";
        echo "<pre>codeVerifier = $this->codeVerifier</pre>";
    }
}
function page_body(){
		require_once( plugin_dir_path( __FILE__ ) . 'sfdc_oauth_web.php' );
}

function delete_plugin_database_table(){
    delete_option('salesforce_sync_client_id'); 
    delete_option('salesforce_sync_client_secret'); 
    //delete_option('salesforce_sync_callback_url'); 


}

register_uninstall_hook( __FILE__ , 'delete_plugin_database_table' );

register_activation_hook ( __FILE__, 'on_activate' );

function on_activate() {
    global $wpdb;
    $create_table_query = "
            CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}salesforce_accounts` (
              `id` bigint(20) NOT NULL AUTO_INCREMENT,
              `sales_force_account_id` text NOT NULL,
              `name` text NOT NULL,
              `account_18_digit_id__c` text NULL,
              PRIMARY KEY  (`id`)
              
            ) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;;
    ";
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    dbDelta( $create_table_query );
}