# [GeoDirectory](http://wpgeodirectory.com/) #
[![Build Status](https://scrutinizer-ci.com/g/GeoDirectory/geodirectory/badges/build.png?b=master)](https://scrutinizer-ci.com/g/GeoDirectory/geodirectory/?branch=master) [![Code Coverage](https://scrutinizer-ci.com/g/GeoDirectory/geodirectory/badges/coverage.png?b=master)](https://scrutinizer-ci.com/g/GeoDirectory/geodirectory/?branch=master) [![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/GeoDirectory/geodirectory/badges/quality-score.png?b=master)](https://scrutinizer-ci.com/g/GeoDirectory/geodirectory/?branch=master) [![License](https://img.shields.io/badge/license-GPL--2.0%2B-red.svg)](https://github.com/GeoDirectory/geodirectory/blob/master/license.txt)

### Welcome to our GitHub Repository

Turn any WordPress theme into a lightning-fast global business directory. Create huge location-based business directories with this fully-featured directory plugin. In a few clicks you could be the next Yelp or Tripadvisor.

More information can be found at [wpgeodirectory.com](http://wpgeodirectory.com/).

## Installation ##

### Minimum Requirements ###

* WordPress 3.1 or greater
* PHP version 5.3 or greater
* MySQL version 5.0 or greater

### Automatic installation ###

Automatic installation is the easiest option. To do an automatic install of GeoDirectory, log in to your WordPress dashboard, navigate to the Plugins menu and click Add New.

In the search field type GeoDirectory and click Search Plugins. Once you've found our Direcotry plugin you install it by simply clicking Install Now. 

Please refer this link. [GeoDirectory basic installation](http://wpgeodirectory.com/docs/basic-installation/)

### Manual installation ###

The manual installation method involves downloading our Directory plugin and uploading it to your webserver via your favourite FTP application. The WordPress codex will tell you more [here](http://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation). 

Please refer this link. [GeoDirectory basic installation](http://wpgeodirectory.com/docs/basic-installation/)

### Updating ###

Automatic updates should seamlessly work. We always suggest you backup up your website before performing any automated update to avoid unforeseen problems.

### Dummy data ###

GeoDirectory comes with some dummy data you can use to see how listings look. You can install dummy data from your GeoDirectory back end. 

## Bugs ##
If you find an issue, let us know [here](https://github.com/GeoDirectory/geodirectory/issues?state=open)!

## Support ##
This is a developer's portal for GeoDirectory and should _not_ be used for support. Please visit the [support forums](https://wpgeodirectory.com/support/).

## Contributions ##
Anyone is welcome to contribute to GeoDirectory. Please read the [guidelines for contributing](https://github.com/GeoDirectory/geodirectory/blob/master/CONTRIBUTING.md) to this repository.

There are various ways you can contribute:

1. Raise an [Issue](https://github.com/GeoDirectory/geodirectory/issues) on GitHub
2. Send us a Pull Request with your bug fixes and/or new features
3. Translate GeoDirectory into [different languages](https://wpgeodirectory.com/translate/projects/geodirectory)

## Features ##

* Create a local directory, based on a single location, using the GeoDirectory free core plugin. Focus on a street or go as wide as a city. Expand to multiple locations or make a global directory with our MultiLocation premium add-on. 
* It provides a front end form that lets you edit through a drag and drop form builder, which allows visitors to submit their listings autonomously. 
* Quickly create a front-end submission form, using GeoDirectory's intuitive drag-and-drop form builder. Users submit listings autonomously. Add any custom field; choose from 13 field types. Use the Advanced Search premium add-on to filter search by any custom field.
* 15+ widgets and 12+ widget areas.
* 2 different Google Maps widgets. Create unlimited categories with ajax-loading custom markers
* Built-in forms for User Reviews, Send-to-Friend and Business Enquiry.
* Search by zip code or location name using the default search widget. Easily filter listings by proximity, rating, reviews or date. Search by user location using the Advanced Search premium add-on.
* List millions of businesses, thanks to our optimized database structure.
* Multilingual site? No problem. GeoDirectory is 100% WPML compatible.
* GeoDirectory is fully compatible with WordPress Multisite.
* CSV import, export, re-import. Easily transfer millions of listings across instances. Edit data offline: live listings automagically update on re-import. You asked for it, we made it.
* Theme Compatibility admin page. Set up GeoDirectory to perform just the way you want with your particular theme. You can even export your settings and use them on new installs.
* Shortcodes for core elements, such as Add, Listing, Popular Post View, Related Listings and many more.
* Yelp-like 'Best Of' widget
* Improved Google Analytics widget for listings owners.
* Titles and metas settings page for better SEO optimization.

## Premium Addons ##

Premium [Addons](http://wpgeodirectory.com/addons/ "Premium addons for GeoDirectory") are provided to extend GeoDirectory and make it a money making global directory toolkit.

* [Events](http://wpgeodirectory.com/addons/events/ "Adds an events manager to your directory") - Adds professional events directory capability. All kind of recurring events options available.
* [MultiLocation](http://wpgeodirectory.com/addons/multilocation/ "Allows to create a global directory") - Create a global directory with Countries, Regions, Cities and Neighbourhoods.
* [Prices and Payments](http://wpgeodirectory.com/addons/prices-and-payments/ "Allows to monetize your directory") - Monetize your website using several payment systems. 
* [Custom Post Types](http://wpgeodirectory.com/addons/custom-post-types/ "Allows to extend your directory categorization") - Adds any custom post type as well as the default "Places", also create Custom post Types with locationless ability. 
* [MultiRatings and Reviews](http://wpgeodirectory.com/addons/multiratings-and-reviews/ "Allows you to extend your rating and reviews categorization") - Extend the review system allowing multiple rating categories (eg: service, quality, price), add images to reviews and other cool features.
* [Advance search filters](http://wpgeodirectory.com/addons/advanced-search-filters/ "Allows you to extended search with custom filters") - Adds advance filters to the search widget, search autocompleter, geolocation and much more (eg: "pet friendly" filter).
* [Buddypress Integration](http://wpgeodirectory.com/addons/buddypress-integration/ "integrates Buddypress with GeoDirectory") - Smoothly integrates GeoDirectory with Buddypress.
* [AffiliateWP Integration](http://wpgeodirectory.com/addons/affiliatewp-integration/ "integrates AffiliateWP with GeoDirectory") - Easily use GeoDirectory with AffiliateWP.
* [Claim Listing Manger](http://wpgeodirectory.com/addons/claim-manager/ "Allows users to claim their business") - Allow business owners to fine-tune their listings, add images, link to events and show an 'owner-verified' badge on the listing. Now with force upgrade option.
* [Marker Cluster](http://wpgeodirectory.com/addons/marker-cluster/ "To avoid overcrowded maps") - Avoid cluttered maps by using numbered markers at high zoom levels. Now with super fast server-side clustering!
* [Duplicate alert](http://wpgeodirectory.com/addons/ajax-duplicate-alert/ "Listing already exists?") - Alert users when they add a listing with the same title as another.
* [Stripe Payment Gateway](http://wpgeodirectory.com/addons/stripe-payment-gateway/ "Extend Prices and Payments with Stripe Payment Geteway") -  Extend the Prices and Payments add-on with this seamless gateway for Stripe.
* [GD Booster](http://wpgeodirectory.com/addons/gd-booster/ "Caching plugin for GeoDirectory") - Watch it fly! GD Booster uses some of the smartest caching, compression and minifying methods available today for WordPress, so your GeoDirectory listings won't hog resources and slow down your site, however many you add. 
* [Custom Google Maps](http://wpgeodirectory.com/addons/custom-google-maps/ "Customize your maps look and feel") - Modify the look and feel of all Google Maps widgets via an intuitive user interface, with color pickers and simple-to-use options.
* [Social Importer](http://wpgeodirectory.com/addons/social-importer/ "Import listings from Facebook and Yelp!") -  Import pages and events from Facebook and listings from Yelp.
* [GD reCAPTCHA](http://wpgeodirectory.com/addons/gd-recaptcha/ "Stop spammers!") - Banish spam by adding the No CAPTCHA reCAPTCHA widget to any GeoDirectory form.


## Go Pro - Become a member! ##

Get your hands on all the premium add-ons and themes. Sign up at [wpgeodirectory.com](http://wpgeodirectory.com/ "Get GeoDirectory membership.").

## Frequently Asked Questions ##

GeoDirectory FAQ can be found [here](http://wpgeodirectory.com/faq/).

## Changelog ##

Changelog can be found [here](http://wpgeodirectory.com/change-logs/)