<?php
/* Template Name: Charity Data */

function flush_charity_cache()
{
    $charity      = array();
    $charities    = array();
    $charity_name = array();
    $count        = 0;
    echo "<br/>";
    for ($i = 1; $i < 20; $i++) {
        $args = array(
            'posts_per_page' => 100,
            'post_type' => 'listing',
            'paged' => $i
        );
        
        $query = new WP_Query($args);
        $posts = $query->posts;

        foreach($posts as $post) {
                
                $charity               = array();
                $charity_exploded      = array();
                $charity['post_title'] = $post->post_title;
                $charity['post_name']  = $post->post_name;
                $cat                   = wp_get_post_terms($post->ID, 'listing_category', array(
                    "fields" => "all"
                ));
                $charity['cat']        = array();
                $charity['don']        = array();
                $charity['catid']      = array();
                $charity['donid']      = array();
                foreach ($cat as $key => $value) {
                    $charity['cat'][$key]['name'] = $value->name;
                    $charity['cat'][$key]['slug'] = $value->slug;
                    $charity['catid'][]           = $value->term_id;
                }
                $don = wp_get_post_terms($post->ID, 'features', array(
                    "fields" => "all"
                ));
                foreach ($don as $key => $value) {
                    $charity['don'][$key]['name'] = $value->name;
                    $charity['don'][$key]['slug'] = $value->slug;
                    $charity['donid'][]           = $value->term_id;
                }
                $charity['acf']['reg_charity_number'] = get_field('reg_charity_number',$post->ID);
                global $wpdb;
                $result         = $wpdb->get_results("SELECT reg_charity_number,status,charitable_spending,total_spending,trustees,employees,volunteers,total_income,website,aims_activities,spending_charitable_activities_val, other_names  FROM `charity_data_master` where `reg_charity_number` = {$charity['acf']['reg_charity_number'] }", ARRAY_A);
                $charity['acf'] = $result[0];

                
                $charity['acf']['range'] = get_field('range',$post->ID);
                
                if ($charity['acf']['total_income'] >= 0 and $charity['acf']['total_income'] < 100000)
                    $charity['acf']['range'] = "0-100k";
                
                if ($charity['acf']['total_income'] >= 100000 and $charity['acf']['total_income'] < 250000)
                    $charity['acf']['range'] = "100k-250k";
                
                if ($charity['acf']['total_income'] >= 250000 and $charity['acf']['total_income'] < 500000)
                    $charity['acf']['range'] = "250k-500k";
                
                if ($charity['acf']['total_income'] >= 500000 and $charity['acf']['total_income'] < 999000)
                    $charity['acf']['range'] = "500k-999k";
                
                if ($charity['acf']['total_income'] >= 999000 and $charity['acf']['total_income'] < 40000000)
                    $charity['acf']['range'] = "999k-40m";
                
                
                $charity['acf']['spending_charitable_activities'] = $charity['acf']['spending_charitable_activities_val'];
                
                unset($charity['acf']['spending_charitable_activities_val']);
                
                if (empty($charity['acf']['total_income']) || $charity['acf']['total_income'] == 0) {
                    if (empty($charity['acf']['total_income'])) {
                        $charity['acf']['spending_charitable_activities_per'] = '';
                    }
                    if ($charity['acf']['total_income'] == 0) {
                        $charity['acf']['spending_charitable_activities_per'] = '';
                    }
                } else {
                    
                    if (empty($charity['acf']['spending_charitable_activities'])) {
                        $charity['acf']['spending_charitable_activities_per'] = '';
                    } else {
                        $charity['acf']['spending_charitable_activities_per'] = round(($charity['acf']['spending_charitable_activities'] / $charity['acf']['total_income']) * 100, 2);
                    }
                }
                         
                
                $charity_name[] = array(
                    'label' => $post->post_title,
                    'id' => $post->post_name
                );
                if (!empty($charity['acf']['other_names'])) {
                    $charity_exploded = explode(',', $charity['acf']['other_names']);
                    
                    foreach ($charity_exploded as $value) {
                        $charity_name[] = array(
                            'label' => $value,
                            'id' => $post->post_name
                        );
                    }
                }
                
                $charity['other_names'] = $charity_exploded;
                
                unset($charity['acf']['other_names']);
                
                $charities[] = $charity;
                
                
                /*     $count++;
                echo $count ." ~" . $post->post_title ." ~" .get_field('reg_charity_number'). "<br/>";*/
            }
          
    }
 

$handle = fopen(get_template_directory() . '/data/charity-autocomplete-temp.json', "w");
fwrite($handle, json_encode($charity_name));
fclose($handle);

rename(get_template_directory() . '/data/charity-autocomplete.json', get_template_directory() . '/data/charity-autocomplete-'.time().'.json');

rename(get_template_directory() . '/data/charity-autocomplete-temp.json', get_template_directory() . '/data/charity-autocomplete.json');

//unlink('/path/to/remove/file.a');


$handle = fopen(get_template_directory() . '/data/charity-temp.json', "w");
fwrite($handle, json_encode($charities));
fclose($handle);

rename(get_template_directory() . '/data/charity.json', get_template_directory() . '/data/charity-'.time().'.json');

rename(get_template_directory() . '/data/charity-temp.json', get_template_directory() . '/data/charity.json');

}



?>
