<?php

function tidy_html($input_string)
{

    $config = array(
        'output-html' => true,
        'indent' => true,
        'wrap' => 800
    );

    // Detect if Tidy is in configured
    if (function_exists('tidy_get_release'))
    {
        $tidy = new tidy;
        $tidy->parseString($input_string, $config, 'raw');
        $tidy->cleanRepair();
        $cleaned_html = tidy_get_output($tidy);
    }
    else
    {
        # Tidy not configured for this Server
        $cleaned_html = $input_string;
    }
    return $cleaned_html;
}

function getxpath($xpath, $path)
{
    $nodelist = $xpath->query($path);
    $node_counts = $nodelist->length; // count how many nodes returned
    $data = '';
    if ($node_counts)
    { // it will be true if the count is more than 0
        foreach ($nodelist as $element)
        {
            $data = $data . $element->nodeValue . "\n";
        }
    }

    return $data;
}

function getCompanyID($xpathcontent) {

    $list = getxpath($xpathcontent,"//a[contains(@href,'Company%3D%')]/@href");

    $from = "Company%3D%";
    $to = "%";

    $companyID = getStringBetween($list,$from,$to);
    echo "<td>" . $companyID . "</td>";
    //var_dump($list);
}

function getComaSeperated($xpathcontent, $xpath)
{
    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath)))))));

    //echo getxpath($xpathcontent, "");
    echo "<td>" . implode(',', $return) . "</td>";

}

function Patern1($xpathcontent, $xpath, $items)
{
    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[0])))))));

    $return = array_pad($return, $items, "");
    foreach ($return as $ff)
    {
        echo "<td>" . $ff . "</td>";
    }

}
function Patern2($xpathcontent, $xpath, $items,$outputSingle)
{
    
    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[0])))))));


    $return = array_pad($return, $items, "");

    if($outputSingle)
    {

      $return = array(implode($return,' '));
    }

    foreach ($return as $ff)
    {
        echo "<td>" . $ff . "</td>";
    }

    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[1])))))));

    $return = array_pad($return, $items, "");

    if($outputSingle)
    {
      $return = array(implode($return,' '));
    }

    foreach ($return as $ff)
    {
        echo "<td>" . $ff . "</td>";
    }
}



function Patern3($xpathcontent, $xpath, $items)
{
    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[0])))))));

    $return = array_pad($return, $items, "");
    foreach ($return as $ff)
    {
        echo "<td>" . $ff . "</td>";
    }

    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[1])))))));

    $return = array_pad($return, $items, "");
    foreach ($return as $ff)
    {
        echo "<td>" . $ff . "</td>";
    }

    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[2])))))));

    $return = array_pad($return, $items, "");
    foreach ($return as $ff)
    {
        echo "<td>" . $ff . "</td>";
    }
}

function getContentFromURL($webAddress)
{

    $options = array(
        'http' => array(
            'method' => "GET",
            'header' => "Connection: keep-alive
    Pragma: no-cache
    Cache-Control: no-cache
    Upgrade-Insecure-Requests: 1
    User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36
    Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8
    Accept-Language: en-US,en;q=0.9"
        )
    );



    //$context = stream_context_create($options);

    $source = file_get_contents($webAddress, false); //download the page
    $clean_source = tidy_html($source);

    $findme   = "loadMap('/scripts/js/";


    $doc = new DOMDocument;

    // suppress errors
    libxml_use_internal_errors(true);

    // load the html source from a string
    $doc->loadHTML($clean_source);
    $xpathcontent = new DOMXPath($doc);
    return $xpathcontent;
}

function getScriptContentFromURL($webAddress, $region)
{

    $options = array(
        'http' => array(
            'method' => "GET",
            'header' => "Connection: keep-alive
    Pragma: no-cache
    Cache-Control: no-cache
    Upgrade-Insecure-Requests: 1
    User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36
    Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8
    Accept-Language: en-US,en;q=0.9"
        )
    );



    //$context = stream_context_create($options);

    $source = file_get_contents($webAddress, false); //download the page
    $clean_source = tidy_html($source);


if($region == 'code') {
    $from = "loadMap('/scripts/js/";
    $to = ".svg'";
    $result = getStringBetween($clean_source,$from,$to);
}
if($region == 'type'){
    $from = "map.getLayer('";
    $to = "').style";

    $result = getStringBetween($clean_source,$from,$to);
}
if($region == 'names'){
    $from = 'var c = "';
    $to = '";';

    $result = getStringBetween($clean_source,$from,$to);
}
    
    return $result;
}


function getStringBetween($str,$from,$to)
{
    $sub = substr($str, strpos($str,$from)+strlen($from),strlen($str));
    return substr($sub,0,strpos($sub,$to));
}