<?php
function mres($value)
{
    $search = array("\\",  "\x00", "\n",  "\r",  "'",  '"', "\x1a");
    $replace = array("\\\\","\\0","\\n", "\\r", "\'", '\"', "\\Z");

    return trim(str_replace($search, $replace, $value),"=");
}

function tidy_html($input_string)
{

    $config = array(
        'output-html' => true,
        'indent' => true,
        'wrap' => 800
    );

    // Detect if Tidy is in configured
    if (function_exists('tidy_get_release'))
    {
        $tidy = new tidy;
        $tidy->parseString($input_string, $config, 'raw');
        $tidy->cleanRepair();
        $cleaned_html = tidy_get_output($tidy);
    }
    else
    {
        # Tidy not configured for this Server
        $cleaned_html = $input_string;
    }
    return preg_replace( "/\r|\n/", "", $cleaned_html );
}

function sanitize_output($buffer) {

    $search = array(
        '/\>[^\S ]+/s',     // strip whitespaces after tags, except space
        '/[^\S ]+\</s',     // strip whitespaces before tags, except space
        '/(\s)+/s',         // shorten multiple whitespace sequences
        '/<!--(.|\s)*?-->/' // Remove HTML comments
    );

    $replace = array(
        '>',
        '<',
        '\\1',
        ''
    );

    $buffer = preg_replace($search, $replace, $buffer);

    return $buffer;
}


function getxpath($xpath, $path)
{
    $nodelist = $xpath->query($path);
    $node_counts = $nodelist->length; // count how many nodes returned
    $data = '';
    if ($node_counts)
    { // it will be true if the count is more than 0
        foreach ($nodelist as $element)
        {
            $data = $data . $element->nodeValue . "\n";
        }
    }

    return $data;
}

function getxpathArray($xpath, $path)
{
    $nodelist = $xpath->query($path);
    $node_counts = $nodelist->length; // count how many nodes returned
    $data = array();
    if ($node_counts)
    { // it will be true if the count is more than 0
        foreach ($nodelist as $element)
        {
            $data[] = $element->nodeValue ;
        }
    }

    return $data;
}

function Patern1($xpathcontent, $xpath, $name, $items)
{
    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[0])))))));

    $return = array_pad($return, $items, "");

    $data = array();
    $count = 0;

    foreach ($return as $ff)
    {

        $data[$name[$count]] = mres($ff);
        $count ++;
    }
    return  $data;

}
function Patern2($xpathcontent, $xpath, $name, $items,$outputSingle)
{
    
    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[0])))))));


    $return = array_pad($return, $items, "");

    if($outputSingle)
    {

      $return = array(implode($return,' '));
    }


    $data = array();
    $count = 0;

    foreach ($return as $ff)
    {

        $data[$name[$count]] = mres($ff);
        $count ++;
    }


    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[1])))))));

    $return = array_pad($return, $items, "");

    if($outputSingle)
    {
      $return = array(implode($return,' '));
    }

    foreach ($return as $ff)
    {

        $data[$name[$count]] = mres($ff);
        $count ++;
    }
    return  $data;
}



function Patern3($xpathcontent, $xpath, $name, $items)
{
    $data = array();
    $count = 0;

    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[0])))))));

    $return = array_pad($return, $items, "");
    foreach ($return as $ff)
    {

        $data[$name[$count]] = mres($ff);
        $count ++;
    }

    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[1])))))));

    $return = array_pad($return, $items, "");
    foreach ($return as $ff)
    {

        $data[$name[$count]] = mres($ff);
        $count ++;
    }

    $return = array_filter(array_map('trim', explode('~', trim(str_replace("\n", '~ ', trim(getxpath($xpathcontent, $xpath[2])))))));

    $return = array_pad($return, $items, "");
    foreach ($return as $ff)
    {

        $data[$name[$count]] = mres($ff);
        $count ++;
    }
    return  $data;
}


function getCleanHTML($webAddress)
{
    $options = array(
        'http' => array(
            'method' => "GET",
            'header' => "Connection: keep-alive
                        Pragma: no-cache
                        Cache-Control: no-cache
                        Upgrade-Insecure-Requests: 1
                        User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36
                        Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8
                        Accept-Language: en-US,en;q=0.9"
        )
    );

    //$timestamp = strtotime('today');
    $timestamp = 1552521600;

    //$context = stream_context_create($options);
    if(file_exists(plugin_dir_path( __FILE__ ) .'cache/'. md5($webAddress). $timestamp))
    {
       $source = file_get_contents(plugin_dir_path( __FILE__ ) .'cache/'. md5($webAddress). $timestamp, false); //download the page 
    }else
    {
        $source = file_get_contents($webAddress, false); //download the page
        $filename = plugin_dir_path( __FILE__ ) .'cache/'. md5($webAddress). $timestamp;
        $handle = fopen($filename,"w");
        fwrite($handle,$source);
        fclose($handle);
    }

    return tidy_html($source);
}

function htmlTableToArray($xpath)
{

$linkText = getxpathArray($xpath, "//div[@id='plTrustee']//div[@class='item-row']/div[@class='trustee-charity-info']//a");
$linkURL = getxpathArray($xpath, "//div[@id='plTrustee']//div[@class='item-row']/div[@class='trustee-charity-info']//a/@href");

$links =array();

foreach ($linkText  as $key => $value) {
    $links[trim($value)] = $linkURL[$key];
}
foreach ($links  as $key => $value) {
    $links[$key] = str_replace("&subid=0", "", str_replace("?regid=", "", $value));
}


    $nodelist = $xpath->query("//div[@id='plTrustee']//div[@class='trustee-name']");
    //$nodelist = $xpath->query("//div[@id='plTrustee']//div[@class='trustee-charity-info']//div");
    //$nodelist = $xpath->query("//div[@id='plTrustee']//div[@class='item-row']");

    $node_counts = $nodelist->length; // count how many nodes returned
    $data = '';
    $trustrees = array();
    if ($node_counts)
    { // it will be true if the count is more than 0
        foreach ($nodelist as $key =>$element)
        {
            $trustrees[$key]['name'] =   $element->nodeValue ;
            $newKey = $key+2;
            //echo getxpath($xpath, "//div[@id='plTrustee']//div[@class='item-row'][{$newKey}]/div//a/@href");
            $trustrees[$key]['charities'] = $charity_name = array_filter(array_map('trim',preg_split('/\r\n|\r|\n/', getxpath($xpath, "//div[@id='plTrustee']//div[@class='item-row'][{$newKey}]/div[@class='trustee-charity-info']//div[@class='trustee-charity-name']"))));
      /*      foreach ($charity_name as $key => $value) {
                $trustrees[$key]['charities'][] =  array('name' => $value, 'id' => $links[$value]);
            }*/
            
        }
    }

/*print_r($trustrees);
exit();*/
    return ($trustrees);
}


function activityhtmlTableToArray($xpath)
{

$activities = getxpathArray($xpath, "//div[@class='latest-activity']//tr/td[2]");
$activityDate = getxpathArray($xpath, "//div[@class='latest-activity']//tr/td[2]/span[1]/text()");

$links =array();

foreach ($activities  as $key => $value) {
    $activityList[] = str_replace($activityDate[$key] ," ( ".$activityDate[$key]." ) on ",trim($value)); //"array('1' => $activityDate[$key],'2' => trim($value));
}
$activityText = implode(", ",$activityList);

//echo "<pre>";
//print_r($activityList);
//exit();

    return  $activityText;
}