<?php
ini_set("display_errors", "0");
error_reporting(E_ALL & ~E_NOTICE);
include "source/scrape.php";
global $scrapeMasterEndole, $scrapeMasterLinkedin, $scrapeMasterCompaniesHouse, $scrapeMasterCompaniesHousePeople;
$scrapeMasterLinkedin = array(
    array(
        "Name" => array("Company Linkedin ID"),
        "Xpaths" => array(""),
        "elements" => -1
    ),

    array(
        "Name" => array("CompanyAbout"),
        "Xpaths" => array("//p[@class='sans-14px-black-75 about__description']"),
        "elements" => 1
    ), 


    array(
        "Name" => array("CompanyAboutDetailsTitle"),
        "Xpaths" => array("//div[@class='about__primary-content']//h3[@class='sans-14px-black-90-bold about__detail-header show-more-only']"),
        "elements" => 1
    ),

    array(
        "Name" => array("CompanyAboutDetailsTitleValue"),
        "Xpaths" => array("//div[@class='about__primary-content']//p[@class='sans-14px-black-75 about__detail-text show-more-only']"),
        "elements" => 1
    ),

    array(
        "Name" => array("EmployeeList"),
        "Xpaths" => array("//ul[@class='employees__list']"),
        "elements" => 1
    ),
);

$scrapeMasterEndole = array(
    array(
        "Display" => 1,
        "Name" => array("RegisteredAddress1"),
        "Xpaths" => array("//td[contains(text(),'Registered Address')]/following-sibling::td/text()[1]"),
        "elements" => 1
    ),
    array(
        "Display" => 1,
        "Name" => array("RegisteredAddress2"),
        "Xpaths" => array("//td[contains(text(),'Registered Address')]/following-sibling::td/text()[2]"),
        "elements" => 1
    ),
    array(
        "Display" => 1,
        "Name" => array("RegisteredAddress3"),
        "Xpaths" => array("//td[contains(text(),'Registered Address')]/following-sibling::td/a"),
        "elements" => 1
    ),
    array(
        "Display" => 1,
        "Name" => array("RegisteredAddress"),
        "Xpaths" => array("//td[contains(text(),'Registered Address')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Name" => array("CountryOrigin"),
        "Xpaths" => array("//td[contains(text(),'Country Origin')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Name" => array("Telephone"),
        "Xpaths" => array("//td[contains(text(),'Telephone')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("EmailAddress"),
        "Xpaths" => array("//td[contains(text(),'Email Address')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("Website"),
        "Xpaths" => array("//td[contains(text(),'Website')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Name" => array("Description"),
        "Xpaths" => array("//div[@id='tiles_Key-Data']//div//p"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("Status"),
        "Xpaths" => array("//td[contains(text(),'Status')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Name" => array("Incorporated"),
        "Xpaths" => array("//td[contains(text(),'Status')]/following-sibling::td"),
        "elements" => 1
    ),

    /*    array(
        "Name" => array("People"),
        "Xpaths" => array("//div[@id='tiles_Key-Data']//div//table//tr[3]//td[2]"),
        "elements" => 1
    ),*/

    array(
        "Display" => 1,
        "Name" => array("Shareholders"),
        "Xpaths" => array("//td[contains(text(),'Shareholders')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("Confirmation"),
        "Xpaths" => array("//td[contains(text(),'Confirmation')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("Accounts"),
        "Xpaths" => array("//td[contains(text(),'Accounts')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("Classification"),
        "Xpaths" => array("//td[contains(text(),'Classification')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("Activity"),
        "Xpaths" => array("//td[contains(text(),'Activity')]/following-sibling::td"),
        "elements" => 1
    ),


    array(
        "Display" => 1,
        "Name" => array("SMESize"),
        "Xpaths" => array("//td[contains(text(),'SME Size')]/following-sibling::td"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("VATNumber"),
        "Xpaths" => array("//div[@id='tiles_Key-Data']//div//table//tr[10]//td[2]"),
        "elements" => 1
    ),


    /*    array(
        "Display" => 1,
        "Name" => array("People"),
        "Xpaths" => array("//div[@id='tiles_People']//div[@class='striped-table']"),
        "elements" => 1
    ),*/

    /*    array(
        "Display" => 1,
        "Name" => array("MutualComapny"),
        "Xpaths" => array("//div[@id='tiles_Mutual-Companies']//div[@class='striped-table']"),
        "elements" => 1
    ),*/

    array(
        "Display" => 1,
        "Name" => array("LatestActivity"),
        "Xpaths" => array(""),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("YearEnded"),
        "Xpaths" => array("//span[contains(text(),'Year Ended')]/following-sibling::span[@class='t1']"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("TotalAssets"),
        "Xpaths" => array("//span[contains(text(),'Total Assets')]/following-sibling::span[@class='t1']"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("TotalLiabilities"),
        "Xpaths" => array("//span[contains(text(),'Total Liabilities')]/following-sibling::span[@class='t1']"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("NetAssets"),
        "Xpaths" => array("//span[contains(text(),'Net Assets')]/following-sibling::span[@class='t1']"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("CashinBank"),
        "Xpaths" => array("//span[contains(text(),'Cash in Bank')]/following-sibling::span[@class='t1']"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("Employees"),
        "Xpaths" => array("//span[contains(text(),'Employees')]/following-sibling::span[@class='t1']"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("TurnOver"),
        "Xpaths" => array("//span[contains(text(),'Turnover')]/following-sibling::span[@class='t1']"),
        "elements" => 1
    ),

    array(
        "Display" => 1,
        "Name" => array("DebtRatio"),
        "Xpaths" => array("//span[contains(text(),'Debt Ratio')]/following-sibling::span[@class='t1']"),
        "elements" => 1
    ),
    array(
        "Display" => 1,
        "Name" => array("Social-LinkedIn"),
        "Xpaths" => array("//td[contains(text(),'Social')]/following-sibling::td/a[@title='LinkedIn']/@href"),
        "elements" => 1
    ),
    array(
        "Display" => 1,
        "Name" => array("Social-Twitter"),
        "Xpaths" => array("//td[contains(text(),'Social')]/following-sibling::td/a[@title='Twitter']/@href"),
        "elements" => 1
    ),
    array(
        "Display" => 1,
        "Name" => array("Social-Facebook"),
        "Xpaths" => array("//td[contains(text(),'Social')]/following-sibling::td/a[@title='Facebook']/@href"),
        "elements" => 1
    ),
    array(
        "Display" => 1,
        "Name" => array("Social-YouTube"),
        "Xpaths" => array("//td[contains(text(),'Social')]/following-sibling::td/a[@title='YouTube']/@href"),
        "elements" => 1
    ),
    array(
        "Display" => 1,
        "Name" => array("Social-Instagram"),
        "Xpaths" => array("//td[contains(text(),'Social')]/following-sibling::td/a[@title='Instagram']/@href"),
        "elements" => 1
    ),
);

$scrapeMasterCompaniesHouse = array(
    array(
        "Name" => array("Company Name"),
        "Xpaths" => array("//p[@id='company-name']"),
        "elements" => 1
    ),

    array(
        "Name" => array("Registered office address"),
        "Xpaths" => array("//dt[contains(text(),'Registered office address')]/following-sibling::dd"),
        "elements" => 1
    ),

    array(
        "Name" => array("Company status"),
        "Xpaths" => array("//dt[contains(text(),'Company status')]/following-sibling::dd"),
        "elements" => 1
    ),
    array(
        "Name" => array("Company type"),
        "Xpaths" => array("//dt[contains(text(),'Company type')]/following-sibling::dd"),
        "elements" => 1
    ),
    array(
        "Name" => array("Incorporated on"),
        "Xpaths" => array("//dt[contains(text(),'Incorporated on')]/following-sibling::dd"),
        "elements" => 1
    ),


    /*
    array(
        "Name" => array("CompanyAccountTitleValue"),
        "Xpaths" => array("//div[@class='grid-row']//div[@class='column-half']"),
        "elements" => 1
    ) ,
    */

    array(
        "Name" => array("NatureOfBusiness"),
        "Xpaths" => array("//span[@id='sic0']"),
        "elements" => 1
    ), 

    /*
    array(
        "Name" => array("NatureOfBusinessValue"),
        "Xpaths" => array("//body[contains(@class,'js-enabled')]/div[@class='entire-wrapper']/main[@id='page-container']/div[@id='content-container']/ul/li[1]"),
        "elements" => 1
    )
    */
);

$scrapeMasterCompaniesHousePeople = array(
    array(
        "Name" => array("Officer Name"),
        "Xpaths" => array("//span[@id='officer-name-" . $count . "']//a"),
        "elements" => 1
    ),

    array(
        "Name" => array("Officer Role"),
        "Xpaths" => array("//span[@id='officer-status-tag-" . $count . "']"),
        "elements" => 1
    ),
    array(
        "Name" => array("Officer Role"),
        "Xpaths" => array("//dd[@id='officer-role-" . $count . "']"),
        "elements" => 1
    ),
    array(
        "Name" => array("Date of Birth"),
        "Xpaths" => array("//dd[@id='officer-date-of-birth-" . $count . "']"),
        "elements" => 1
    ),
    array(
        "Name" => array("Appointed on"),
        "Xpaths" => array("//dd[@id='officer-appointed-on-" . $count . "']"),
        "elements" => 1
    ),
    array(
        "Name" => array("Resigned on"),
        "Xpaths" => array("//dd[@id='officer-resigned-on-" . $count . "']"),
        "elements" => 1
    ),
    array(
        "Name" => array("Nationality"),
        "Xpaths" => array("//dd[@id='officer-nationality-" . $count . "']"),
        "elements" => 1
    ),
    array(
        "Name" => array("Country of Residence"),
        "Xpaths" => array("//dd[@id='officer-country-of-residence-" . $count . "']"),
        "elements" => 1
    ),
    array(
        "Name" => array("Occupation"),
        "Xpaths" => array("//dd[@id='officer-occupation-" . $count . "']"),
        "elements" => 1
    ), 
);

function getFromPageEndole($webAddress, $id)
{
        global $xpaths, $headers,$scrapeMasterEndole;

        $scrapeMaster = $scrapeMasterEndole;

        $str = getCleanHTML($webAddress);

        if(empty($str))
        {
            $data['reg_company_number'] = $id;
            return $data;
        }
 
        $xpathcontent = getContentFromURL($webAddress);

        $data =array();

        foreach ($scrapeMaster as $xpath)
        {
            $data['reg_company_number'] = $id;
             if(!isset($xpath['Display'])|| $xpath['Display'] != 1)
             {
            continue;
             }
             
            if(isset($xpath["Xpaths"]))
            {
                switch (count($xpath["Xpaths"])) {
                    case 1:
                    if((isset($xpath["elements"]) && $xpath["elements"] == 1) || (isset($xpath["coma-seperated"]) && $xpath["coma-seperated"] == TRUE))
                    {
                        $data = array_merge($data, getComaSeperated($xpathcontent, $xpath["Xpaths"][0], $xpath["Name"][0],$xpath));
                    }
                    else{
                        $data = array_merge($data, Patern1($xpathcontent, $xpath["Xpaths"], $xpath["Name"], $xpath['elements']));
                    }
                    break;
                    case 2:
                        $data = array_merge($data,Patern2($xpathcontent, $xpath["Xpaths"], $xpath["Name"], $xpath['elements'], false));
                    break;
                    case 3:

                        $data = array_merge($data,Patern3($xpathcontent, $xpath["Xpaths"], $xpath["Name"], $xpath['elements']));
                    break;
                    default:
                        # code...
                        break;
                }
            }
            if(isset($xpath["regx"]))
            {
                         $data = array_merge($data,findStringRegex($str, $xpath["regx"][0], $xpath["Name"][0]));
            }

           $data['LatestActivity'] = activityhtmlTableToArray($xpathcontent);
          // $data['LatestActivity'] = '';
            
        }

return $data;

}



function getFromPageCompanieshouse($webAddress, $id)
{
        global $xpaths, $headers,$scrapeMaster,$scrapeMasterCompaniesHouse;
      

        $str = getCleanHTML($webAddress);

        if(empty($str))
        {
            $data['reg_company_number'] = $id;
            return $data;
        }

        $xpathcontent = getContentFromURL($webAddress);
        $data =array();

        foreach ($scrapeMasterCompaniesHouse as $xpath)
        {
            $data['reg_company_number'] = $id;

            if(isset($xpath["Xpaths"]))
            {
                switch (count($xpath["Xpaths"])) {
                    case 1:
                    if((isset($xpath["elements"]) && $xpath["elements"] == 1) || (isset($xpath["coma-seperated"]) && $xpath["coma-seperated"] == TRUE))
                    {
                        $data = array_merge($data, getComaSeperated($xpathcontent, $xpath["Xpaths"][0], $xpath["Name"][0],$xpath));
                    }
                    else{
                        $data = array_merge($data, Patern1($xpathcontent, $xpath["Xpaths"], $xpath["Name"], $xpath['elements']));
                    }
                    break;
                    case 2:
                        $data = array_merge($data,Patern2($xpathcontent, $xpath["Xpaths"], $xpath["Name"], $xpath['elements'], false));
                    break;
                    case 3:

                        $data = array_merge($data,Patern3($xpathcontent, $xpath["Xpaths"], $xpath["Name"], $xpath['elements']));
                    break;
                    default:
                        # code...
                        break;
                }
            }
            if(isset($xpath["regx"]))
            {
                         $data = array_merge($data,findStringRegex($str, $xpath["regx"][0], $xpath["Name"][0]));
            }
            
        }
    return $data;
}

function getFromPageLinkedin($webAddress, $id)
{
        global $xpaths, $headers,$scrapeMaster,$scrapeMasterLinkedin;
        $xpathcontent = getContentFromURL($webAddress);

        $str = getCleanHTML($webAddress);

        $data =array();

        foreach ($scrapeMaster as $xpath)
        {
            $data['reg_company_number'] = $id;

            if(isset($xpath["Xpaths"]))
            {
                switch (count($xpath["Xpaths"])) {
                    case 1:
                    if((isset($xpath["elements"]) && $xpath["elements"] == 1) || (isset($xpath["coma-seperated"]) && $xpath["coma-seperated"] == TRUE))
                    {
                        $data = array_merge($data, getComaSeperated($xpathcontent, $xpath["Xpaths"][0], $xpath["Name"][0],$xpath));
                    }
                    else{
                        $data = array_merge($data, Patern1($xpathcontent, $xpath["Xpaths"], $xpath["Name"], $xpath['elements']));
                    }
                    break;
                    case 2:
                        $data = array_merge($data,Patern2($xpathcontent, $xpath["Xpaths"], $xpath["Name"], $xpath['elements'], false));
                    break;
                    case 3:

                        $data = array_merge($data,Patern3($xpathcontent, $xpath["Xpaths"], $xpath["Name"], $xpath['elements']));
                    break;
                    default:
                        # code...
                        break;
                }
            }
            if(isset($xpath["regx"]))
            {
                         $data = array_merge($data,findStringRegex($str, $xpath["regx"][0], $xpath["Name"][0]));
            }
            
        }

return $data;
}


function displayData($companyID, $linkedInURL)
{?>
    <style>
  .dataValue{
    border: 1px double #ccc;
    padding: 0.5em;
  }
  .dataHeading {
    font-weight: bold;
    color: green;$companyID
    font-size: 14px;
  }
  .dataHeading::after {
    content: ":";
  }
  .dataRow{
    white-space: normal;
    padding: 10px;
  }
  input[type="hidden"]{
    margin:0px;
    padding: 0px;

  }
  </style>
  <?php


    /*https://beta.companieshouse.gov.uk/company/06174001
    https://suite.endole.co.uk/insight/company/07037852-spts-technologies-limited
    https://www.linkedin.com/company/theladbible-group
    https://www.linkedin.com/company/10302475 */

    $dataFromEndole = $dataFromCompanieshouse = $dataFromLinkedin = array();

       $dataFromEndole = getFromPageEndole("https://suite.endole.co.uk/insight/company/".$companyID, $companyID);
   //    $dataFromCompanieshouse = getFromPageCompanieshouse('https://beta.companieshouse.gov.uk/company/'.$companyID,$companyID);
       //$dataFromLinkedin = getFromPageLinkedin($linkedInURL,$companyID);
       $dataAll = array_merge($dataFromEndole,$dataFromCompanieshouse);
      // $dataAll = array_merge($dataAll,$dataFromLinkedin);
            print_r($dataAll);
            exit();
       display($dataAll);

}





function displayDataTable()
{
$servername = "localhost";
$username = "root";
$password = '';
$dbname = "muslim_sites_data";
global $conn;

// Create connection

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection

if ($conn->connect_error)
    {
    die("Connection failed: " . $conn->connect_error);
    }

$sql = "SELECT * FROM `companies` WHERE `FetchStatus` <> 1 LIMIT 0,1";

$result = $conn->query($sql);

if ($result->num_rows > 0)
    {

    // output data of each row

    while ($row = $result->fetch_assoc())
        {
        $Company_Registration_Number__c = trim($row["Company_Registration_Number__c"]);
        $data = insetData($Company_Registration_Number__c);


        $conn->query("UPDATE `companies` SET `FetchStatus` = '1' WHERE `Company_Registration_Number__c` = '{$Company_Registration_Number__c}';");
        $count = $conn->query("SELECT count(*) FROM `companies` WHERE `FetchStatus` = 1");
        $row = $count->fetch_row();
        echo '#: ', $row[0].'</br>';
        echo 'Company_Registration_Number__c : '.$Company_Registration_Number__c .'</br>Traffic :'. $data['Engagments_Visits'];
        echo "<pre>";
        print_r($data);   

        //sleep(rand(1,2));

        echo "<script> window.onload = function () { window.location.reload() } </script> ";
        }
    
    }
  else
    {
    echo "0 results";
    }

$conn->close();


}

function insetData($companyIDs)
{

global $scrapeMasterCompaniesHouse,$scrapeMasterEndole;

$companyIDList = explode(',', $companyIDs);



 foreach ($companyIDList as $id)
{

    $cid = str_pad($id,8,"0",STR_PAD_LEFT);

        $dataFromEndole = $dataFromCompanieshouse = $dataFromLinkedin = array();

       $dataFromEndole = getFromPageEndole("https://suite.endole.co.uk/insight/company/".$cid, $cid);
       //$dataFromCompanieshouse = getFromPageCompanieshouse('https://beta.companieshouse.gov.uk/company/'.$id,$id);
       //$dataFromLinkedin = getFromPageLinkedin($linkedInURL,$id);
       $dataAll = array_merge($dataFromEndole,$dataFromCompanieshouse);
      // $dataAll = array_merge($dataAll,$dataFromLinkedin);
       return createCompanyDataRow($id,$dataAll);


}

  




}

function displayDataTable1()
{


    global $scrapeMasterCompaniesHouse,$scrapeMasterEndole;
    $companyIDs = "302461,11589572,11280430,3443712,6910058,198032,7891350,5271664,9910179";

    $companyIDList = explode(',', $companyIDs);
    $masterConfig = array_merge($scrapeMasterEndole,$scrapeMasterCompaniesHouse);

    ?>
    <style>
      .dataValue{
        border: 1px double #ccc;
        padding: 0.5em;
      }
      .dataHeading {
        font-weight: bold;
        color: green;$companyID
        font-size: 14px;
      }
      .dataHeading::after {
        content: ":";
      }
      .dataRow{
        white-space: normal;
        padding: 10px;
      }
      input[type="hidden"]{
        margin:0px;
        padding: 0px;

      }
      </style>
  <?php
    $list_expoted = explode(",", $list);
    echo "<!DOCTYPE html><html><meta charset='utf-8'><body><table border=1 >";
    echo "<tr>"; 
    echo "<th>CompanyNo</th>";
     foreach ($masterConfig as $xpath)
    {
         foreach ($xpath['Name'] as $name)
        {
            if(isset($xpath['Display']) && $xpath['Display'] == 1)
            echo "<th>" . $name . "</th>";
        }  
    }


 foreach ($companyIDList as $id)
    {

    $id = str_pad($id,8,"0",STR_PAD_LEFT);

        $dataFromEndole = $dataFromCompanieshouse = $dataFromLinkedin = array();

       $dataFromEndole = getFromPageEndole("https://suite.endole.co.uk/insight/company/".$id, $id);
       //$dataFromCompanieshouse = getFromPageCompanieshouse('https://beta.companieshouse.gov.uk/company/'.$id,$id);
       //$dataFromLinkedin = getFromPageLinkedin($linkedInURL,$id);
       $dataAll = array_merge($dataFromEndole,$dataFromCompanieshouse);
      // $dataAll = array_merge($dataAll,$dataFromLinkedin);
            
        echo '<tr>';
        foreach ($dataAll as $key => $value) {

    echo "<td>{$value}</td>";

        }
        echo '</tr>';
    }

    echo "</table></body></html>";   

}



function display($data)
{


    echo " <div class='dataContainer'>";

    echo "  <div class='dataRow'>";
        foreach ($data as $key => $value) {

    echo "<div class='dh_dv_container'><div class='dataHeading'>{$key}</div><div class='dataValue'>{$value}</div></div>";

        }


    echo "</div>";
    ?>

        <form method="get" action="admin.php?page=manage_companies&action=add">
        
        <div class="chart_mana_final_submission">
        <input type="hidden" name="page" value="manage_companies"/>
        <input type="hidden" name="action" value="add"/>
        <input type="hidden" name="company_id" value="<?php echo $_GET['company_id']; ?>" />

        Accept and Create a company :
        <input type="checkbox" name="approve" />

        <input type="submit" name="Submit" class="chart_man_submt" />
        </div>
        </form>
    <?php

}



function createCompanyDataRow($companyID,$dataAll) {
    global $conn;


 //   $companyCheck = $wpdb->get_var( "SELECT COUNT(*) `company_data_master` WHERE `reg_company_number` = {$companyID}" );


  $fields = array('RegisteredAddress1', 'RegisteredAddress2', 'RegisteredAddress3', 'RegisteredAddress', 'EmailAddress', 'Website', 'Status', 'Shareholders', 'Confirmation', 'Accounts', 'Classification', 'Activity', 'SMESize', 'VATNumber', 'LatestActivity', 'YearEnded', 'TotalAssets', 'TotalLiabilities', 'NetAssets', 'CashinBank', 'Employees', 'TurnOver', 'DebtRatio', 'Social-LinkedIn', 'Social-Twitter', 'Social-Facebook', 'Social-YouTube', 'Social-Instagram');


  foreach ($fields as  $value) {
      if(isset($dataAll[$value]) && !empty($dataAll[$value]))
      {
        $dataAll[$value] = $conn->real_escape_string($dataAll[$value]);
       $conn->query("UPDATE `companies` SET `{$value}` = '{$dataAll[$value]}'  WHERE `Company_Registration_Number__c` = '{$companyID}';");
      }
  }
  return($dataAll);

} 

?>

