/************************************************************************
 *************************************************************************
 @Name :        jRating - jQuery Plugin
 @Revison :        3.0 (Modified by Geodirectory Team)
 @Date :        28/01/2013
 @Author:         ALPIXEL - (www.myjqueryplugins.com - www.alpixel.fr)
 @License :         Open Source - MIT License : http://www.opensource.org/licenses/mit-license.php

 **************************************************************************
 *************************************************************************/
(function ($) {
    $.fn.jRating = function (op) {
        var defaults = {
            /** String vars **/
            bigStarsPath: 'jquery/icons/stars.png', // path of the icon stars.png
            smallStarsPath: 'jquery/icons/small.png', // path of the icon small.png
            phpPath: 'php/jRating.php', // path of the php file jRating.php
            type: 'big', // can be set to 'small' or 'big'

            /** Boolean vars **/
            step: false, // if true,  mouseover binded star by star,
            isDisabled: false,
            showRateInfo: true,
            canRateAgain: false,

            /** Integer vars **/
            length: 5, // number of star to display
            decimalLength: 0, // number of decimals.. Max 3, but you can complete the function 'getNote'
            rateMax: 20, // maximal rate - integer from 0 to 9999 (or more)
            rateInfosX: -45, // relative position in X axis of the info box when mouseover
            rateInfosY: 5, // relative position in Y axis of the info box when mouseover
            nbRates: 1,

            /** Functions **/
            onSuccess: null,
            onError: null,
            onTouchstart: null
        };

        if (this.length > 0)
            return this.each(function () {
                /*vars*/
                var opts = $.extend(defaults, op),
                    newWidth = 0,
                    starWidth = 0,
                    starHeight = 0,
                    bgPath = '',
                    hasRated = false,
                    globalWidth = 0,
                    nbOfRates = opts.nbRates;

                if ($(this).hasClass('jDisabled') || opts.isDisabled)
                    var jDisabled = true;
                else
                    var jDisabled = false;

                getStarWidth();
                $(this).height(starHeight);
                var average = parseFloat($(this).attr('data-average')), // get the average of all rates
                    idBox = parseInt($(this).attr('data-id')), // get the id of the box
                    widthRatingContainer = (starWidth * opts.length) - 1, // Width of the Container
                    widthColor = average / opts.rateMax * widthRatingContainer, // Width of the color Container


                    quotient =
                        $('<div>',
                            {
                                'class': 'jRatingColor',
                                css: {
                                    width: widthColor
                                }
                            }).appendTo($(this)),

                    average =
                        $('<div>',
                            {
                                'class': 'jRatingAverage',
                                css: {
                                    width: 0,
                                    top: -starHeight
                                }
                            }).appendTo($(this)),

                    jstar =
                        $('<div>',
                            {
                                'class': 'jStar',
                                css: {
                                    width: widthRatingContainer,
                                    height: starHeight,
                                    top: -(starHeight * 2),
                                    background: 'url(' + bgPath + ') repeat-x'
                                }
                            }).appendTo($(this));

                if (widthColor > 0) {
                    average.width(widthColor);
                    quotient.width(0);
                    hasRated = true;
                    globalWidth = widthColor;
                }

                $(this).css({width: widthRatingContainer, overflow: 'hidden', zIndex: 1, position: 'relative'});

                if (!jDisabled)
                    $(this).unbind().bind({
                        mouseenter: function (e) {
                            var realOffsetLeft = findRealLeft(this);
                            var relativeX = e.pageX - realOffsetLeft;
                            if (opts.showRateInfo)
                                var tooltip =
                                    $('<p>', {
                                        'class': 'jRatingInfos',
                                        html: getNote(relativeX) + ' <span class="maxRate">/ ' + opts.rateMax + '</span>',
                                        css: {
                                            top: (e.pageY + opts.rateInfosY),
                                            left: (e.pageX + opts.rateInfosX)
                                        }
                                    }).appendTo('body').show();
                            //quotient.width(0);
                        },
                        mouseover: function (e) {
                            $(this).css('cursor', 'pointer');
                        },
                        mouseout: function () {
                            $(this).css('cursor', 'default');
                            if (hasRated) {
                                average.width(globalWidth);
                            }
                            else {
                                average.width(0);
                            }
                        },
                        mousemove: function (e) {
                            var realOffsetLeft = findRealLeft(this);
                            var relativeX = e.pageX - realOffsetLeft;
                            if (opts.step) newWidth = Math.floor(relativeX / starWidth) * starWidth + starWidth;
                            else newWidth = relativeX;
                            average.width(newWidth);
                            if (opts.showRateInfo)
                                $("p.jRatingInfos")
                                    .css({
                                        left: (e.pageX + opts.rateInfosX)
                                    })
                                    .html(getNote(newWidth) + ' <span class="maxRate">/ ' + opts.rateMax + '</span>');
                        },
                        mouseleave: function () {
                            $("p.jRatingInfos").remove();
                        },
                        click: function (e) {
                            var element = this;

                            /*set vars*/
                            hasRated = true;
                            globalWidth = newWidth;
                            nbOfRates--;

                            if (!opts.canRateAgain || parseInt(nbOfRates) <= 0) $(this).unbind().css('cursor', 'default').addClass('jDisabled');

                            if (opts.showRateInfo) $("p.jRatingInfos").fadeOut('fast', function () {
                                $(this).remove();
                            });
                            e.preventDefault();
                            var rate = getNote(newWidth);
                            average.width(newWidth);


                            /** ONLY FOR THE DEMO, YOU CAN REMOVE THIS CODE **/
                            $('.datasSent p').html('<strong>idBox : </strong>' + idBox + '<br /><strong>rate : </strong>' + rate + '<br /><strong>action :</strong> rating');
                            $('.serverResponse p').html('<strong>Loading...</strong>');
                            /** END ONLY FOR THE DEMO **/

                            if (opts.onSuccess) opts.onSuccess(element, rate);

                            /*$.post(opts.phpPath,{
                             idBox : idBox,
                             rate : rate,
                             action : 'rating'
                             },
                             function(data) {
                             if(!data.error)
                             {
                             if(opts.onSuccess) opts.onSuccess( element, rate );
                             }
                             else
                             {
                             if(opts.onError) opts.onError( element, rate );
                             }
                             },
                             'json'
                             );*/
                        },
                        touchstart: function (e) {
                            var element = this;
                            var realOffsetLeft = findRealLeft(this);
                            var xPos = e.originalEvent.touches[0].pageX;
                            var relativeX = xPos - realOffsetLeft;
                            //Taken from mousemove
                            if (opts.step) newWidth = Math.floor(relativeX / starWidth) * starWidth + starWidth;
                            else newWidth = relativeX;
                            /*set vars*/
                            hasRated = true;
                            globalWidth = newWidth;
                            nbOfRates--;
                            if (!opts.canRateAgain || parseInt(nbOfRates) <= 0) $(this).unbind().css('cursor', 'default').addClass('jDisabled');
                            if (opts.showRateInfo) $("p.jRatingInfos").fadeOut('fast', function () {
                                $(this).remove();
                            });
                            e.preventDefault();
                            var rate = getNote(newWidth);
                            average.width(newWidth);
                            if (opts.onTouchstart) opts.onTouchstart(element, rate);
                        }
                    });

                function getNote(relativeX) {
                    var noteBrut = parseFloat((relativeX * 100 / widthRatingContainer) * opts.rateMax / 100);
                    switch (opts.decimalLength) {
                        case 1 :
                            var note = Math.round(noteBrut * 10) / 10;
                            break;
                        case 2 :
                            var note = Math.round(noteBrut * 100) / 100;
                            break;
                        case 3 :
                            var note = Math.round(noteBrut * 1000) / 1000;
                            break;
                        default :
                            var note = Math.round(noteBrut * 1) / 1;
                    }
                    if (note > opts.rateMax) {
                        note = opts.rateMax;
                    }
                    return note;
                };

                function getStarWidth() {
                    switch (opts.type) {
                        case 'small' :
                            starWidth = 12; // width of the picture small.png
                            starHeight = 10; // height of the picture small.png
                            bgPath = opts.smallStarsPath;
                            break;
                        default :
                            starWidth = 23; // width of the picture stars.png
                            starHeight = 20; // height of the picture stars.png
                            bgPath = opts.bigStarsPath;
                    }
                };

                function findRealLeft(obj) {
                    if (!obj) return 0;
                    return obj.offsetLeft + findRealLeft(obj.offsetParent);
                };
            });

    }
})(jQuery);